import { useState, useEffect } from 'react'
import { CookiesProvider, useCookies } from 'react-cookie'
import { useNavigate } from "react-router-dom"

const api_uri = import.meta.env.VITE_API_URI
const api_port = import.meta.env.VITE_API_PORT
const session_ttl = import.meta.env.VITE_SESSION_TTL

function AuthVerify() {
  const [loading, setLoading] = useState(true)
  const [session, setSession, removeSession] = useCookies(['auth'])
  const queryParameters = new URLSearchParams(window.location.search)
  const token = queryParameters.get("token")
  const navigate = useNavigate()

  useEffect(() => {
    (async () => {
      // check token validity on API endpoint
      const response = await fetch(`${api_uri}:${api_port}/v1/auth/verify?token=${token}`)
      const { message, data, error } = await response.json()

      if (error) {
        alert(error)
      } else {
        // Set client session (https://www.npmjs.com/package/react-cookie)
        setSession('auth', data, {
          path: '/',
          // https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Set-Cookie#samesitesamesite-value
          sameSite: 'strict',
          secure: process.env.NODE_ENV !== 'development',
          maxAge: parseInt(session_ttl),
        })

        // Redirect if everything ok. Use navigate in an effect:
        // https://reactrouter.com/en/main/hooks/use-navigate
        return navigate("/");
      }
    })();
  }, []);

  return (
    <div className="AuthVerify">
    </div>
  )
}

export default AuthVerify;
