import { useState } from 'react'

const session_ttl = import.meta.env.VITE_SESSION_TTL
const api_uri = import.meta.env.VITE_API_URI
const api_port = import.meta.env.VITE_API_PORT

function Auth() {
  const [loading, setLoading] = useState(false)
  const [email, setEmail] = useState('')

  const handleLogin = async (e) => {
    e.preventDefault()

    try {
      setLoading(true)

      const response = await fetch(`${api_uri}:${api_port}/v1/auth/requestMagicLink`, {
        method: 'POST',
        headers: {'Content-Type': 'application/json'},
        body: JSON.stringify({"email": email}),
      })

      const { data, error } = await response.json()
      if (error) {
        alert(error)
      } else {
        alert('Check your email for the login link!')
      }
    } catch (error) {
      alert(error.error_description || error.message)
    } finally {
      setLoading(false)
    }
  }

  return (
    <div className="Auth">
      <div>
        <button disabled={!loading}>{loading ? '🛸 sending magic link ...' : ''}</button>
        <h1>Login</h1>
        <p>Sign in with a magic link.</p>
        <div className='loginForm'>
          <form onSubmit={handleLogin}>
            <input
              id="email"
              type="email"
              placeholder="Your email"
              value={email}
              onChange={(e) => setEmail(e.target.value)}
            /><br/>
            <button>🛸 Send magic link</button>
          </form>
        </div>
        <h1>Registration</h1>
        <p>No account yet? Contact event administrator to sign up.</p>
      </div>
    </div>
  )
}

export default Auth;
