-- Summarize all scores of a heat
create or replace view score_summary
  with (security_invoker=on)
  as
  select a.id as athlete_id, s.heat as heat_id, SUM(s.score) as score_summary
  from scores s
  join athletes as a on a.id = s.athlete
  group by a.id, s.heat;

-- Create distinct set of athletes (startlist) from a set of heats
create or replace function distinct_startlist(heat_ids numeric[])
returns table(id bigint, athlete bigint, nr bigint, firstname text, lastname text,
birthday date, school text)
language plpgsql
set search_path = ''
as $$
begin
  return query
  select distinct on (a.id) s.id, a.id, a.nr, a.firstname, a.lastname, a.birthday, a.school
  from public.startlist as s
  join public.athletes as a on s.athlete = a.id
  where s.heat = any (heat_ids);
end;
$$;

begin;
-- Remove the myheats_realtime publication
drop publication if exists myheats_realtime;

-- Re-create the myheats_realtime publication with no tables
create publication myheats_realtime;
commit;

-- Add a table to the publication
alter publication myheats_realtime add table scores;