CREATE TABLE public.startlist (
    id bigint NOT NULL,
    created_at timestamp with time zone DEFAULT now(),
    heat bigint NOT NULL,
    athlete bigint NOT NULL
);

ALTER TABLE public.startlist ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.startlist_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);

ALTER TABLE ONLY public.startlist
    ADD CONSTRAINT startlist_pkey PRIMARY KEY (heat, athlete);

ALTER TABLE ONLY public.startlist
    ADD CONSTRAINT startlist_athlete_fkey FOREIGN KEY (athlete) REFERENCES public.athletes(id) ON DELETE CASCADE;

ALTER TABLE ONLY public.startlist
    ADD CONSTRAINT startlist_heat_fkey FOREIGN KEY (heat) REFERENCES public.heats(id) ON DELETE CASCADE;
