CREATE TABLE public.scores (
    id bigint NOT NULL,
    created_at timestamp with time zone DEFAULT now(),
    athlete bigint NOT NULL,
    judge bigint NOT NULL,
    score double precision,
    heat bigint NOT NULL
);

ALTER TABLE public.scores ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.score_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);

ALTER TABLE ONLY public.scores
    ADD CONSTRAINT scores_pkey PRIMARY KEY (athlete, judge, heat);

ALTER TABLE ONLY public.scores
    ADD CONSTRAINT scores_athlete_fkey FOREIGN KEY (athlete) REFERENCES public.athletes(id) ON DELETE CASCADE;

ALTER TABLE ONLY public.scores
    ADD CONSTRAINT scores_heat_fkey FOREIGN KEY (heat) REFERENCES public.heats(id) ON DELETE CASCADE;

ALTER TABLE ONLY public.scores
    ADD CONSTRAINT scores_judge_fkey FOREIGN KEY (judge) REFERENCES public.judges(id) ON DELETE CASCADE;
