CREATE TABLE public.heats (
    id bigint NOT NULL,
    created_at timestamp with time zone DEFAULT now(),
    name text NOT NULL,
    location text,
    planned_start time without time zone,
    CONSTRAINT heats_name_check CHECK ((length(name) > 0))
);

ALTER TABLE public.heats ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.heats_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);

ALTER TABLE ONLY public.heats
    ADD CONSTRAINT heats_pkey PRIMARY KEY (id);
