CREATE TABLE public.athletes (
    id bigint NOT NULL,
    created_at timestamp with time zone DEFAULT now(),
    nr bigint,
    firstname text NOT NULL,
    lastname text,
    birthday date,
    school text,
    CONSTRAINT athletes_firstname_check CHECK ((length(firstname) > 0))
);

ALTER TABLE public.athletes ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.athletes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);

ALTER TABLE ONLY public.athletes
    ADD CONSTRAINT athletes_pkey PRIMARY KEY (id);
