# Digitalocean deployment

Build instructions for Digital Ocean.

Estimated monthly:
* App cost: $17.00 (2x$5 services + $7 PostgreSQL db)
* Managed external db: $15
* Droplet (incl. db, app services): $6

https://www.digitalocean.com/pricing

## Build and push images

1 - Prepare build environment (variables are fixed during "vite build" step):

```bash
export VITE_APP_DOC_TITLE='My title'
# use NODE_ENV=prod to exclude the `devDependencies` (e.g., vite)
export NODE_ENV=dev
```

2 - Build frontend and push:

```bash
# https://cloud.digitalocean.com/account/api/tokens
podman login registry.digitalocean.com/myheats

buildah bud --no-cache \
  --build-arg="VITE_APP_DOC_TITLE=$VITE_APP_DOC_TITLE" \
  --build-arg="NODE_ENV=$NODE_ENV" \
  --network=slirp4netns \
  -t registry.digitalocean.com/myheats/myheats:latest .

buildah push registry.digitalocean.com/myheats/myheats:latest
```

3 - Build backend/api and push:

```bash
# https://code.in0rdr.ch/nomad/file/docker/docker-myheats-api/Dockerfile.html
buildah bud --no-cache \
  --network=slirp4netns \
  -t registry.digitalocean.com/myheats/myheats:api .

buildah push registry.digitalocean.com/myheats/myheats:api
```

## App service setup

Use `../dev/digital-ocean-app.yaml` app spec to configure the app in Digital Ocean

## Droplet setup

Cheap and cheerful.

1 - Create droplet

2 - Create user
  - Configure ssh key and sshd agent
  - Configure sudoers
  - Install podman
  - Configure certbot

3 - Clone repos (Podman and db schema)

```bash
git clone --depth=1 https://git.in0rdr.ch/myheats.git myheats.git
git clone --depth=1 https://git.in0rdr.ch/nomad.git nomad.git
cd nomad.git/docker/docker-myheats-nginx/
```

4 - Run podman services (frontend, api, db)

```bash
sudo podman login registry.digitalocean.com/myheats
sudo podman-compose up -d
```
