# Development setup

Define the environment variables for frontend/backend according to the example
in `./dev/env`.

## Nix development environment
You can create a nix-shell for development purposes:
```
nix-shell nix/shell.nix
```

## Docker environment
The docker-compose environment in the `./dev` folder configures a PostgreSQL database
with Adminer interface:
* https://hub.docker.com/_/postgres
* https://github.com/docker-library/docs/blob/master/postgres/README.md

The Adminer can be accessed at http://127.0.0.1:8080 with the default
username/password `postgres`/`example`.

The database is automatically initialized at start. To re-initialize the
database tables manually, source the sql files from `../schema`:
```
# use "example" default password to apply
cat ../schema/*.sql | psql -h 127.0.0.1 -U postgres -p 5432
```
