# My Heats
Live heats, scoring and leaderboard for sport events.

This React application was build using [Vite](https://vitejs.dev) (`npm create
vite@latest . --template react`) and the following core componentes:
* [`react-router-dom`](https://reactrouter.com) for routing between the React
  components
* [`postgres`](https://github.com/porsager/postgres#realtime-subscribe) for
  realtime subscription to leaderboard changes with PostgreSQL publication
* [`react-select`](https://react-select.com) for the selectbox widgets

## Running the App
```bash
# Install dependencies
npm install

# Export all required environment variables, see example in .env

# Start authentication API backend
npm run api

# Start app frontend
npm run dev
```

See `./docs` for more detailed developer documentation.

## Scoring and ranking logic
The scoring and ranking logic is defined in `utils.js` inside the `rankByHeat`
function. Following ranking options can be selected. Rank by:
* Start number: Rank by athlete start number
* Best heat: Rank by best heat (and by least worst if "best" is equally good)
* Worst heat: Ranks worst heats only (no further comparison by best if equally
  bad)
* Total: Ranks by sum of all selected heats

## Database schema
The PostgreSQL database schema is stored in the `schema` folder and can be
created using plain psql.

To update the schema from the current database, use (example for table
`startlist`):
```bash
pg_dump -h 127.0.0.1 -U postgres -t 'public.startlist' --schema-only > schema/04-startlist.sql
```

The views and functions from `./schema/99-init-db.sql` are required. Among
others, this enables [PostgreSQL
publication](https://www.postgresql.org/docs/current/logical-replication-publication.html)
so the leaderboard can automatically update scores when they are created or
changed by judges ("realtime functionality").

## Authentication with magic links
Authentication of judges is performed using Magic links.

Sign up process for new judges:
* The judge is required to have a valid email address
* Judges can be invied to the scoring backend by invite only (table `public.judges`)

Sign in process:
* For sign in, the judge enters her email adress and receives a login link
* The login information is stored in the browser session until sign out

## Real-time replication
The database user needs permissions to start `walsender`. Otherwise you
encounter this error:
```
must be superuser or replication role to start walsender
```

To give the permissions:
```sql
ALTER USER myheats REPLICATION;
\du
```

Also, the wal level needs to be set to `logical` in the postgresql config.
Otherwise, this is the error message you will receive:
```
logical decoding requires wal_level >= logical
```

To set it in `postgresql.conf`:
```
# postgresql.conf
wal_level = logical                     # minimal, replica, or logical
```

Restart database.

## Bulk import/export
Use direct postgres database access:
```bash
psql -h 127.0.0.1 -U postgres
```

To import data from local csv:
```sql
\copy public.scores from 'scores_rows.csv' DELIMITER ',' CSV HEADER;
```

To export data to local csv:
```sql
\copy public.scores to 'scores_rows.csv' DELIMITER ',' CSV HEADER;
```

## Settings
The following settings can be applied in `/settings` as parameters to configure
the them and appearance of the leaderboard:
* `style`: The color of the navigation elements, one of `yellow`, `blue` or `red`
* `logoUrl`: Add url to a logo to replace the default logo in the footer
* `showLogo`: Set to "false" to hide the logo in the footer
* `showVersion`: Set to "false" to hide the version in the footer

## Development & contributions
For a list of contributors see the [AUTHORS.md](./AUTHORS.md).

* All source code is available in this repository. Contributions are always
  welcome! Pull requests at https://pr.in0rdr.ch/repos/myheats
* A [Kanban
  board](https://board.in0rdr.ch/public/board/c445667f1c999857f6149cad967fa44f196f2e9fef02069c5f5136e036dd)
documents plans, todos and decisions for further development of the project.

## Community and support
For question and support visit
[#p0c/libera](https://web.libera.chat/gamja/#p0c) on IRC.

## License
This work uses the MIT License. See [LICENSE](./LICENSE) for details.
