package main

import (
	"hivedav/config"
	"net/http"
	"net/http/httptest"
	"strings"
	"testing"
)

var server *Server

func TestServer(t *testing.T) {
	config := config.Config{
		ListenAddress:  "[::]",
		ListenPort:     3737,
		CaldavUri:      "/",
		Calendar:       0,
		CaldavUser:     "gandalf",
		CaldavPassword: "ring",
	}
	server, err := server.NewServer(&config)
	if err != nil {
		t.Fatal("Could not create hivedav server")
	}

	// ResponseRecorder is an implementation of http.ResponseWriter that
	// records its mutations for later inspection in tests.
	// https://pkg.go.dev/net/http/httptest
	rr := httptest.NewRecorder()

	request, err := http.NewRequest("GET", "/", nil)

	// test curlable UI
	request.Header.Set("user-agent", "curl/8.1.2")
	server.Index(rr, request, nil)

	if err != nil {
		t.Fatal("error creating new request:", err)
	}

	if status := rr.Code; status != http.StatusOK {
		t.Errorf("request to / returned wrong response code. Got %v, want %v",
			status, http.StatusOK)
	}

	welcome := rr.Body.String()
	if !strings.Contains(welcome, "Hive") {
		t.Errorf("request to / does not contain word 'Hive'")
	}

	// test regular browser UI
	request.Header.Set("user-agent", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36")
	server.Index(rr, request, nil)

	if err != nil {
		t.Fatal("error creating new request:", err)
	}

	if status := rr.Code; status != http.StatusOK {
		t.Errorf("request to / returned wrong response code. Got %v, want %v",
			status, http.StatusOK)
	}

	welcome = rr.Body.String()
	if !strings.Contains(welcome, "hive") {
		t.Errorf("request to / does not contain word 'hive'")
	}
}
