# CalDav requests

## Request flow
CalDav request flow is as follows:
1. Get user principal
2. Find home set of user principal
3. Get calendar from home set
4. Fetch all events from calendar and sync availability

To debug the flow, use the xml snippets from the code and curl.

## Tested providers
* GMX
  - example 1: `HIVEDAV_CALDAV_HOST=https://caldav.gmx.net` and
    `HIVEDAV_CALENDAR=1`
  - example 2:
    `HIVEDAV_CALDAV_URI=https://caldav.gmx.net/begenda/dav/$PRINCIPAL/calendar`
  - https://hilfe.gmx.net/kalender/mobil/apps.html
* Yahoo
  - create app password for `HIVEDAV_CALDAV_PASSWORD` at
    https://login.yahoo.com/myaccount/security/app-password
  - example 1: `HIVEDAV_CALDAV_HOST=https://caldav.calendar.yahoo.com` and
    `HIVEDAV_CALENDAR=1`
  - example 2:
    `HIVEDAV_CALDAV_URI=https://caldav.calendar.yahoo.com/dav/$PRINCIPAL/Calendar/$CALENDAR_ID`
  - https://help.yahoo.com/kb/SLN4707.html
* Kopano (with calendar discovery, use `HIVEDAV_CALDAV_HOST`)
  - example: `HIVEDAV_CALDAV_HOST=https://mail.server.com:8443`
  - https://documentation.kopano.io/user_manual_kopanocore/configure_caldav_clients.html

If you are unsure on how to retrieve the `HIVEDAV_CALDAV_URI` for a specific
provider, follow the example flow below to manually discover a particular
calendar CalDav uri.

## Generic flow example
These curl commands depict the request flow from the Go code and should work
with any provider.

First, read the principal:
```
cat <<EOF | curl -s -d @- -XPROPFIND -H "Content-Type: text/xml" -H "Depth: 0" \
  -u '$USER:$PASSWORD' -L $CALDAV_HOST | xmllint --format -
<d:propfind xmlns:d="DAV:">
 <d:prop>
  <d:current-user-principal />
 </d:prop>
</d:propfind>
EOF
```
The principal path (`$PRINCIPAL`) is returned in the XML response tag
`<DAV:current-user-principal>`. For some providers, `$CALDAV_HOST` has a
special prefix (such as `/begenda/dav/users` for GMX, follow the 302 redirect
location with curl).

Get calendar home set for the principal:
```
cat <<EOF | curl -s -d @- -XPROPFIND -H "Content-Type: text/xml" -H "Depth: 0" \
  -u '$USER:$PASSWORD' $CALDAV_HOST/$PRINCIPAL | xmllint --format -
<d:propfind xmlns:d="DAV:" xmlns:c="urn:ietf:params:xml:ns:caldav">
 <d:prop>
  <c:calendar-home-set />
 </d:prop>
</d:propfind>
EOF
```

The users calendar home set `$HOME_SET` is returned in the
`<calendar-home-set>` XML tag.

This home set contains all calendars of the user. Finally, to list the
calendars (`HIVEDAV_CALDAV_URI`):
```
cat <<EOF | curl -s -d @- -XPROPFIND -H "Content-Type: text/xml" -H "Depth: 1" \
  -u '$USER:$PASSWORD' $CALDAV_HOST/$HOME_SET | xmllint --format -
<d:propfind xmlns:d="DAV:" xmlns:cs="http://calendarserver.org/ns/" xmlns:c="urn:ietf:params:xml:ns:caldav">
 <d:prop>
  <d:resourcetype />
  <d:displayname />
  <cs:getctag />
  <c:supported-calendar-component-set />
 </d:prop>
</d:propfind>
EOF
```

Choose a calendar CalDav URI (`HIVEDAV_CALDAV_URI`) to sync with a particular
calendar.
